/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BGAboutWindow
extends JFrame
implements ActionListener {
    private JFrame myOwner;
    private JLabel jlabMain;
    private JLabel jlabSubtitle;
    private ImageIcon imgLogo;
    private JLabel jlabLogo;
    private JButton jbutClose;

    public BGAboutWindow(JFrame jFrame) {
        this.setTitle("About " + BarGen.getStrApplicationName() + " " + BarGen.getStrApplicationVersion());
        this.setDefaultCloseOperation(2);
        jFrame.setEnabled(false);
        this.myOwner = jFrame;
        this.setBackground(Color.white);
        this.initGUI();
        this.setVisible(true);
    }

    public void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(15, 15, 0, 15);
        this.jlabMain = new JLabel("About " + BarGen.getStrApplicationName(), 0);
        Font font = new Font("sanserif", 1, 30);
        this.jlabMain.setForeground(Color.red);
        this.jlabMain.setFont(font);
        BGUtil.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 20);
        gridBagLayout.setConstraints(this.jlabMain, gridBagConstraints);
        jPanel.add(this.jlabMain);
        gridBagConstraints.insets = new Insets(0, 15, 15, 15);
        this.jlabSubtitle = new JLabel("Version " + BarGen.getStrApplicationVersion() + "  (" + BarGen.getStrApplicationVDate() + ")", 0);
        Font font2 = new Font("sanserif", 1, 12);
        this.jlabSubtitle.setForeground(Color.red);
        this.jlabSubtitle.setFont(font2);
        BGUtil.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 10);
        gridBagLayout.setConstraints(this.jlabSubtitle, gridBagConstraints);
        jPanel.add(this.jlabSubtitle);
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        URL uRL = this.getClass().getResource("/applogo.png");
        this.imgLogo = uRL != null ? new ImageIcon(uRL) : new ImageIcon();
        this.jlabLogo = new JLabel("", this.imgLogo, 0);
        BGUtil.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 40);
        gridBagLayout.setConstraints(this.jlabLogo, gridBagConstraints);
        jPanel.add(this.jlabLogo);
        String string = BarGen.getStrApplicationName() + " was created in 2004 when I worked on some barcode issues.\n";
        string = string + "\n";
        string = string + "The usage of " + BarGen.getStrApplicationName() + " is for free and entirely at own risk. All rights remain at the author.\n";
        string = string + "\n";
        string = string + BarGen.getStrApplicationName() + " uses external Java classes from Barbecue project.\n";
        string = string + "Further information can be found at:\n";
        string = string + "http://barbecue.sourceforge.net/\n";
        string = string + "\n";
        string = string + "Currently, there are some limitations. Please read documentation for details.\n";
        string = string + "Maybe additional features will be added depending on time issues, feedback and further improvements of Barbecue project.\n";
        string = string + "\n";
        string = string + "Copyright \u00a9 2004 by Jochen-Matthias Wienke";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setHighlighter(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jTextArea);
        jScrollPane.setMinimumSize(new Dimension(200, 150));
        jScrollPane.setPreferredSize(new Dimension(430, 240));
        jScrollPane.setBorder(null);
        gridBagConstraints.fill = 0;
        BGUtil.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 40);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(30, 15, 15, 15);
        this.jbutClose = new JButton("Close");
        this.jbutClose.setMnemonic('c');
        this.jbutClose.addActionListener(this);
        BGUtil.buildConstraints(gridBagConstraints, 0, 3, 2, 1, 100, 10);
        gridBagLayout.setConstraints(this.jbutClose, gridBagConstraints);
        this.jbutClose.setToolTipText("Close Window");
        jPanel.add(this.jbutClose);
        this.setContentPane(jPanel);
        this.pack();
        BGUtil.centerComponent(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BGAboutWindow.this.closeWindow();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutClose) {
            this.closeWindow();
        }
    }

    private void closeWindow() {
        this.myOwner.setEnabled(true);
        this.myOwner.validate();
        this.myOwner.requestFocus();
        this.setVisible(false);
        this.myOwner.toFront();
        this.dispose();
    }
}

