/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.output.EPSOutput;
import net.sourceforge.barbecue.output.OutputException;
import net.sourceforge.barbecue.output.SVGOutput;

public class BGViewWindow
extends JFrame
implements ActionListener,
Printable {
    private BarGen myOwner;
    private JFileChooser jfcSave;
    private ExampleFileFilter effEPS;
    private ExampleFileFilter effGIF;
    private ExampleFileFilter effJPG;
    private ExampleFileFilter effPNG;
    private ExampleFileFilter effSVG;
    private PrinterJob printJob;
    private PageFormat selectedFormat;
    private JLabel jlabMain;
    private Barcode barcode;
    private JButton jbutPageSetup;
    private JButton jbutPrint;
    private JButton jbutSave;
    private JButton jbutClose;

    public BGViewWindow(BarGen barGen) {
        this.setTitle("View Barcode");
        this.setDefaultCloseOperation(2);
        barGen.setEnabled(false);
        this.myOwner = barGen;
        this.barcode = barGen.getBarcode();
        this.initGUI();
        this.jfcSave = new JFileChooser();
        this.jfcSave.setDialogTitle("Save Barcode Image");
        this.jfcSave.setDialogType(1);
        this.jfcSave.setFileSelectionMode(0);
        this.jfcSave.setAcceptAllFileFilterUsed(false);
        this.effEPS = new ExampleFileFilter();
        this.effEPS.setDescription("EPS Graphic");
        this.effEPS.addExtension("eps");
        this.jfcSave.addChoosableFileFilter(this.effEPS);
        this.effGIF = new ExampleFileFilter();
        this.effGIF.setDescription("GIF Image");
        this.effGIF.addExtension("gif");
        this.jfcSave.addChoosableFileFilter(this.effGIF);
        this.effJPG = new ExampleFileFilter();
        this.effJPG.setDescription("JPG Image");
        this.effJPG.addExtension("jpg");
        this.effJPG.addExtension("jpeg");
        this.jfcSave.addChoosableFileFilter(this.effJPG);
        this.effPNG = new ExampleFileFilter();
        this.effPNG.setDescription("PNG Image");
        this.effPNG.addExtension("png");
        this.jfcSave.addChoosableFileFilter(this.effPNG);
        this.effSVG = new ExampleFileFilter();
        this.effSVG.setDescription("SVG Graphic");
        this.effSVG.addExtension("svg");
        this.jfcSave.addChoosableFileFilter(this.effSVG);
        this.jfcSave.setFileFilter(this.effPNG);
        this.printJob = PrinterJob.getPrinterJob();
        this.selectedFormat = this.printJob.defaultPage();
        this.setVisible(true);
    }

    public void initGUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.jlabMain = new JLabel("View Barcode", 0);
        Font font = new Font("sanserif", 1, 30);
        this.jlabMain.setForeground(Color.red);
        this.jlabMain.setFont(font);
        BGUtil.buildConstraints(gridBagConstraints, 0, 0, 4, 1, 100, 20);
        gridBagLayout.setConstraints(this.jlabMain, gridBagConstraints);
        jPanel.add(this.jlabMain);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.ipadx = 5;
        gridBagConstraints2.ipady = 5;
        BGUtil.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 100, 100);
        gridBagLayout2.setConstraints(this.barcode, gridBagConstraints2);
        jPanel2.add(this.barcode);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel2);
        jScrollPane.setMinimumSize(new Dimension(150, 150));
        jScrollPane.setBorder(null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(40, 15, 20, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 1, 4, 1, 100, 50);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(50, 15, 15, 15);
        this.jbutPageSetup = new JButton("Page Format");
        this.jbutPageSetup.setMnemonic('f');
        this.jbutPageSetup.addActionListener(this);
        BGUtil.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 25, 30);
        gridBagLayout.setConstraints(this.jbutPageSetup, gridBagConstraints);
        this.jbutPageSetup.setToolTipText("Page Format");
        jPanel.add(this.jbutPageSetup);
        this.jbutPrint = new JButton("Print");
        this.jbutPrint.setMnemonic('p');
        this.jbutPrint.addActionListener(this);
        BGUtil.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 25, 30);
        gridBagLayout.setConstraints(this.jbutPrint, gridBagConstraints);
        this.jbutPrint.setToolTipText("Print Barcode");
        jPanel.add(this.jbutPrint);
        this.jbutSave = new JButton("Save");
        this.jbutSave.setMnemonic('s');
        this.jbutSave.addActionListener(this);
        BGUtil.buildConstraints(gridBagConstraints, 2, 2, 1, 1, 25, 30);
        gridBagLayout.setConstraints(this.jbutSave, gridBagConstraints);
        this.jbutSave.setToolTipText("Save Image");
        jPanel.add(this.jbutSave);
        this.jbutClose = new JButton("Close");
        this.jbutClose.setMnemonic('c');
        this.jbutClose.addActionListener(this);
        BGUtil.buildConstraints(gridBagConstraints, 3, 2, 1, 1, 25, 30);
        gridBagLayout.setConstraints(this.jbutClose, gridBagConstraints);
        this.jbutClose.setToolTipText("Close Window");
        jPanel.add(this.jbutClose);
        this.setContentPane(jPanel);
        this.pack();
        BGUtil.centerComponent(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BGViewWindow.this.closeWindow();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutClose) {
            this.closeWindow();
        } else if (object == this.jbutSave) {
            if (!this.saveBarcodeImage()) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this, "Image file couldn't get saved.", "Error", 0);
            }
        } else if (object == this.jbutPrint) {
            if (!this.printBarcode()) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this, "Barcode couldn't get printed.", "Error", 0);
            }
        } else if (object == this.jbutPageSetup) {
            this.selectedFormat = this.printJob.pageDialog(this.selectedFormat);
            this.myOwner.toFront();
            this.toFront();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            try {
                this.barcode.draw(graphics2D, 0, 0);
            }
            catch (OutputException outputException) {
                System.out.println("An exception occured during Output:\n" + outputException);
            }
            return 0;
        }
        return 1;
    }

    private void closeWindow() {
        this.myOwner.setEnabled(true);
        this.myOwner.validate();
        this.myOwner.requestFocus();
        this.setVisible(false);
        this.myOwner.toFront();
        this.dispose();
    }

    public boolean saveBarcodeImage() {
        boolean bl = false;
        int n = this.jfcSave.showSaveDialog(this);
        if (n == 0) {
            try {
                String string = this.jfcSave.getSelectedFile().getCanonicalPath();
                try {
                    if (this.jfcSave.getFileFilter() == this.effEPS) {
                        FileWriter fileWriter = new FileWriter(string);
                        EPSOutput ePSOutput = new EPSOutput(fileWriter);
                        this.barcode.output(ePSOutput);
                        fileWriter.close();
                        bl = true;
                    } else if (this.jfcSave.getFileFilter() == this.effGIF) {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        BarcodeImageHandler.writeGIF(this.barcode, fileOutputStream);
                        fileOutputStream.close();
                        bl = true;
                    } else if (this.jfcSave.getFileFilter() == this.effJPG) {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        BarcodeImageHandler.writeJPEG(this.barcode, fileOutputStream);
                        fileOutputStream.close();
                        bl = true;
                    } else if (this.jfcSave.getFileFilter() == this.effPNG) {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        BarcodeImageHandler.writePNG(this.barcode, fileOutputStream);
                        fileOutputStream.close();
                        bl = true;
                    } else if (this.jfcSave.getFileFilter() == this.effSVG) {
                        FileWriter fileWriter = new FileWriter(string);
                        Font font = new Font("Arial", 0, this.myOwner.getIntFontSize());
                        Color color = new Color(0, 0, 0);
                        Color color2 = new Color(255, 255, 255);
                        double d = 0.0078125;
                        String string2 = "in";
                        SVGOutput sVGOutput = new SVGOutput(fileWriter, font, color, color2, d, string2);
                        this.barcode.output(sVGOutput);
                        fileWriter.close();
                        bl = true;
                    }
                }
                catch (OutputException outputException) {
                    System.out.println("An exception occured during Output:\n" + outputException);
                }
            }
            catch (IOException iOException) {
                System.out.println("An exception occured during saving file:\n" + iOException);
            }
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean printBarcode() {
        boolean bl = false;
        this.printJob.setJobName("BarGen Print Job");
        this.printJob.setPrintable(this, this.selectedFormat);
        if (this.printJob.printDialog()) {
            try {
                this.printJob.print();
                bl = true;
            }
            catch (Exception exception) {}
        } else {
            bl = true;
        }
        this.myOwner.toFront();
        this.toFront();
        return bl;
    }
}

