/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BarcodeFactory;

public class BarGen
extends JFrame
implements ActionListener,
ItemListener {
    private static final String strApplicationName = "BarGen";
    public static final String strApplicationVersion = "1.18";
    public static final String strApplicationVDate = "2011-06-03";
    private Barcode barcode;
    private String strCode;
    private int intBarWidth;
    private int intBarHeight;
    private int intResolution;
    private boolean boolPrintCode;
    private int intFontSize;
    private JLabel jlabTitle;
    private JLabel jlabSubTitle;
    private JLabel jlabCodeHeadline;
    private JTextField jtxtfCode;
    private JLabel jlabBarcodeType;
    private JComboBox jcomboBarcodeType;
    private JLabel jlabBarWidth;
    private JTextField jtxtfBarWidth;
    private JLabel jlabBarHeight;
    private JTextField jtxtfBarHeight;
    private JLabel jlabResolution;
    private JTextField jtxtfResolution;
    private JCheckBox jchkbPrintCode;
    private JLabel jlabFontSize;
    private JTextField jtxtfFontSize;
    private JButton jbutGenerate;
    private JButton jbutAbout;
    private JButton jbutQuit;

    public BarGen() {
        this.setTitle(BarGen.getStrApplicationName() + " " + BarGen.getStrApplicationVersion());
        this.initVars();
        this.initGUI();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BarGen.quitProgramme();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setVisible(true);
    }

    private void initVars() {
        this.strCode = "My Barcode";
        this.intBarWidth = 1;
        this.intBarHeight = 100;
        this.intResolution = 300;
        this.boolPrintCode = true;
        this.intFontSize = 16;
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(20, 15, 0, 15);
        this.jlabTitle = new JLabel(BarGen.getStrApplicationName(), 0);
        gridBagConstraints.anchor = 15;
        BGUtil.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 100, 30);
        Font font = new Font("sanserif", 1, 30);
        this.jlabTitle.setForeground(Color.red);
        this.jlabTitle.setFont(font);
        this.jlabTitle.setVerticalAlignment(3);
        gridBagLayout.setConstraints(this.jlabTitle, gridBagConstraints);
        jPanel.add(this.jlabTitle);
        this.jlabSubTitle = new JLabel("Barcode Generation Tool", 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 15, 25, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 20);
        Font font2 = new Font("sanserif", 1, 12);
        this.jlabSubTitle.setForeground(Color.red);
        this.jlabSubTitle.setFont(font2);
        this.jlabSubTitle.setVerticalAlignment(1);
        gridBagLayout.setConstraints(this.jlabSubTitle, gridBagConstraints);
        jPanel.add(this.jlabSubTitle);
        this.jlabCodeHeadline = new JLabel("Code:", 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 15, 0, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 5);
        gridBagLayout.setConstraints(this.jlabCodeHeadline, gridBagConstraints);
        jPanel.add(this.jlabCodeHeadline);
        this.jtxtfCode = new JTextField(new LimitedLengthDocument(50), this.strCode, 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 15, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 3, 3, 1, 100, 5);
        gridBagLayout.setConstraints(this.jtxtfCode, gridBagConstraints);
        jPanel.add(this.jtxtfCode);
        this.jlabBarcodeType = new JLabel("Barcode Type:", 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 4, 3, 1, 100, 5);
        gridBagLayout.setConstraints(this.jlabBarcodeType, gridBagConstraints);
        jPanel.add(this.jlabBarcodeType);
        this.jcomboBarcodeType = new JComboBox();
        this.jcomboBarcodeType.addItem("2 of 7");
        this.jcomboBarcodeType.addItem("3 of 9");
        this.jcomboBarcodeType.addItem("Bookland");
        this.jcomboBarcodeType.addItem("Codabar");
        this.jcomboBarcodeType.addItem("Code 128 (Switched)");
        this.jcomboBarcodeType.addItem("Code 128A");
        this.jcomboBarcodeType.addItem("Code 128B");
        this.jcomboBarcodeType.addItem("Code 128C");
        this.jcomboBarcodeType.addItem("Code 39");
        this.jcomboBarcodeType.addItem("EAN-128");
        this.jcomboBarcodeType.addItem("EAN-13");
        this.jcomboBarcodeType.addItem("GTIN");
        this.jcomboBarcodeType.addItem("Interleaved 2 of 5");
        this.jcomboBarcodeType.addItem("Monarch");
        this.jcomboBarcodeType.addItem("NW-7");
        this.jcomboBarcodeType.addItem("PDF417");
        this.jcomboBarcodeType.addItem("PostNet");
        this.jcomboBarcodeType.addItem("Random Weight UPC-A");
        this.jcomboBarcodeType.addItem("SCC-14");
        this.jcomboBarcodeType.addItem("SIDN");
        this.jcomboBarcodeType.addItem("SSCC-18");
        this.jcomboBarcodeType.addItem("Standard 2 of 5");
        this.jcomboBarcodeType.addItem("UCC-128");
        this.jcomboBarcodeType.addItem("UPC-A");
        this.jcomboBarcodeType.addItem("USD-3");
        this.jcomboBarcodeType.addItem("USD-4");
        this.jcomboBarcodeType.addItem("USPS");
        this.jcomboBarcodeType.setToolTipText("Select Barcode Type");
        this.jcomboBarcodeType.setSelectedIndex(6);
        gridBagConstraints.insets = new Insets(0, 15, 20, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 5, 3, 1, 100, 5);
        gridBagLayout.setConstraints(this.jcomboBarcodeType, gridBagConstraints);
        this.jcomboBarcodeType.addActionListener(this);
        jPanel.add(this.jcomboBarcodeType);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.ipadx = 5;
        gridBagConstraints2.ipady = 5;
        this.jlabBarWidth = new JLabel("Bar Width:", 0);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 17, 100);
        gridBagLayout2.setConstraints(this.jlabBarWidth, gridBagConstraints2);
        jPanel2.add(this.jlabBarWidth);
        this.jtxtfBarWidth = new JTextField(new LimitedLengthDocument(2), "" + this.intBarWidth, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 1, 0, 1, 1, 8, 100);
        gridBagLayout2.setConstraints(this.jtxtfBarWidth, gridBagConstraints2);
        jPanel2.add(this.jtxtfBarWidth);
        this.jlabBarHeight = new JLabel("Bar Height:", 0);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 2, 0, 1, 1, 17, 100);
        gridBagLayout2.setConstraints(this.jlabBarHeight, gridBagConstraints2);
        jPanel2.add(this.jlabBarHeight);
        this.jtxtfBarHeight = new JTextField(new LimitedLengthDocument(3), "" + this.intBarHeight, 3);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 3, 0, 1, 1, 12, 100);
        gridBagLayout2.setConstraints(this.jtxtfBarHeight, gridBagConstraints2);
        jPanel2.add(this.jtxtfBarHeight);
        this.jlabResolution = new JLabel("Resolution:", 0);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 4, 0, 1, 1, 20, 100);
        gridBagLayout2.setConstraints(this.jlabResolution, gridBagConstraints2);
        jPanel2.add(this.jlabResolution);
        this.jtxtfResolution = new JTextField(new LimitedLengthDocument(4), "" + this.intResolution, 4);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints2, 5, 0, 1, 1, 16, 100);
        gridBagLayout2.setConstraints(this.jtxtfResolution, gridBagConstraints2);
        jPanel2.add(this.jtxtfResolution);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 15, 20, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 6, 3, 1, 100, 5);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.ipadx = 5;
        gridBagConstraints3.ipady = 5;
        this.jchkbPrintCode = new JCheckBox("Print Code Text", this.boolPrintCode);
        this.jchkbPrintCode.addItemListener(this);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints3, 0, 0, 1, 1, 50, 100);
        gridBagLayout3.setConstraints(this.jchkbPrintCode, gridBagConstraints3);
        jPanel3.add(this.jchkbPrintCode);
        this.jlabFontSize = new JLabel("Font Size:", 0);
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints3, 1, 0, 1, 1, 15, 100);
        gridBagLayout3.setConstraints(this.jlabFontSize, gridBagConstraints3);
        jPanel3.add(this.jlabFontSize);
        this.jtxtfFontSize = new JTextField(new LimitedLengthDocument(2), "" + this.intFontSize, 2);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 2, 0, 0);
        BGUtil.buildConstraints(gridBagConstraints3, 2, 0, 1, 1, 35, 100);
        gridBagLayout3.setConstraints(this.jtxtfFontSize, gridBagConstraints3);
        jPanel3.add(this.jtxtfFontSize);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 15, 20, 15);
        BGUtil.buildConstraints(gridBagConstraints, 0, 7, 3, 1, 100, 5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(50, 15, 15, 15);
        this.jbutGenerate = new JButton("Generate");
        this.jbutGenerate.setMnemonic('g');
        BGUtil.buildConstraints(gridBagConstraints, 0, 8, 1, 1, 33, 40);
        this.jbutGenerate.addActionListener(this);
        this.jbutGenerate.setToolTipText("Generate Barcode");
        gridBagLayout.setConstraints(this.jbutGenerate, gridBagConstraints);
        jPanel.add(this.jbutGenerate);
        this.jbutAbout = new JButton("About");
        this.jbutAbout.setMnemonic('a');
        BGUtil.buildConstraints(gridBagConstraints, 1, 8, 1, 1, 33, 40);
        this.jbutAbout.addActionListener(this);
        this.jbutAbout.setToolTipText("About " + BarGen.getStrApplicationName());
        gridBagLayout.setConstraints(this.jbutAbout, gridBagConstraints);
        jPanel.add(this.jbutAbout);
        this.jbutQuit = new JButton("Quit");
        this.jbutQuit.setMnemonic('q');
        BGUtil.buildConstraints(gridBagConstraints, 2, 8, 1, 1, 34, 40);
        this.jbutQuit.addActionListener(this);
        this.jbutQuit.setToolTipText("Quit Application");
        gridBagLayout.setConstraints(this.jbutQuit, gridBagConstraints);
        jPanel.add(this.jbutQuit);
        this.setContentPane(jPanel);
        this.pack();
        BGUtil.centerComponent(this);
    }

    public String getStrCode() {
        return this.strCode;
    }

    public int getIntBarWidth() {
        return this.intBarWidth;
    }

    public int getIntBarHeight() {
        return this.intBarHeight;
    }

    public int getIntResolution() {
        return this.intResolution;
    }

    public boolean getBoolPrintCode() {
        return this.boolPrintCode;
    }

    public int getIntFontSize() {
        return this.intFontSize;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public static String getStrApplicationName() {
        return strApplicationName;
    }

    public static String getStrApplicationVersion() {
        return strApplicationVersion;
    }

    public static String getStrApplicationVDate() {
        return strApplicationVDate;
    }

    private static void quitProgramme() {
        System.exit(0);
    }

    public boolean processFieldValues() {
        boolean bl = false;
        String string = this.jtxtfCode.getText();
        if (string != null && string.length() > 0) {
            this.strCode = string;
            string = this.jtxtfBarWidth.getText();
            Integer n = BGUtil.editStringToInteger(string);
            if (n != null && n > 0) {
                this.intBarWidth = n;
                this.jtxtfBarWidth.setText("" + this.intBarWidth);
                string = this.jtxtfBarHeight.getText();
                n = BGUtil.editStringToInteger(string);
                if (n != null && n > 0) {
                    this.intBarHeight = n;
                    this.jtxtfBarHeight.setText("" + this.intBarHeight);
                    string = this.jtxtfResolution.getText();
                    n = BGUtil.editStringToInteger(string);
                    if (n != null && n > 0) {
                        this.intResolution = n;
                        this.jtxtfResolution.setText("" + this.intResolution);
                        string = this.jtxtfFontSize.getText();
                        n = BGUtil.editStringToInteger(string);
                        if (n != null && n > 0) {
                            this.intFontSize = n;
                            this.jtxtfFontSize.setText("" + this.intFontSize);
                            bl = true;
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this, "Please enter a valid Font Size.", "Error", 0);
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, "Please enter a valid Resolution.", "Error", 0);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this, "Please enter a valid Bar Height.", "Error", 0);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this, "Please enter a valid Bar Width.", "Error", 0);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Please enter a code.", "Error", 0);
        }
        return bl;
    }

    public boolean generateBarcode() {
        boolean bl = false;
        try {
            switch (this.jcomboBarcodeType.getSelectedIndex()) {
                case 0: {
                    this.barcode = BarcodeFactory.create2of7(this.getStrCode());
                    bl = true;
                    break;
                }
                case 1: {
                    this.barcode = BarcodeFactory.create3of9(this.getStrCode(), this.askCheckSumRequired());
                    bl = true;
                    break;
                }
                case 2: {
                    this.barcode = BarcodeFactory.createBookland(this.getStrCode());
                    bl = true;
                    break;
                }
                case 3: {
                    this.barcode = BarcodeFactory.createCodabar(this.getStrCode());
                    bl = true;
                    break;
                }
                case 4: {
                    this.barcode = BarcodeFactory.createCode128(this.getStrCode());
                    bl = true;
                    break;
                }
                case 5: {
                    this.barcode = BarcodeFactory.createCode128A(this.getStrCode());
                    bl = true;
                    break;
                }
                case 6: {
                    this.barcode = BarcodeFactory.createCode128B(this.getStrCode());
                    bl = true;
                    break;
                }
                case 7: {
                    this.barcode = BarcodeFactory.createCode128C(this.getStrCode());
                    bl = true;
                    break;
                }
                case 8: {
                    this.barcode = BarcodeFactory.createCode39(this.getStrCode(), this.askCheckSumRequired());
                    bl = true;
                    break;
                }
                case 9: {
                    this.barcode = BarcodeFactory.createEAN128(this.getStrCode());
                    bl = true;
                    break;
                }
                case 10: {
                    this.barcode = BarcodeFactory.createEAN13(this.getStrCode());
                    bl = true;
                    break;
                }
                case 11: {
                    this.barcode = BarcodeFactory.createGlobalTradeItemNumber(this.getStrCode());
                    bl = true;
                    break;
                }
                case 12: {
                    this.barcode = BarcodeFactory.createInt2of5(this.getStrCode(), this.askCheckSumRequired());
                    bl = true;
                    break;
                }
                case 13: {
                    this.barcode = BarcodeFactory.createMonarch(this.getStrCode());
                    bl = true;
                    break;
                }
                case 14: {
                    this.barcode = BarcodeFactory.createNW7(this.getStrCode());
                    bl = true;
                    break;
                }
                case 15: {
                    this.barcode = BarcodeFactory.createPDF417(this.getStrCode());
                    bl = true;
                    break;
                }
                case 16: {
                    this.barcode = BarcodeFactory.createPostNet(this.getStrCode());
                    bl = true;
                    break;
                }
                case 17: {
                    this.barcode = BarcodeFactory.createRandomWeightUPCA(this.getStrCode());
                    bl = true;
                    break;
                }
                case 18: {
                    this.barcode = BarcodeFactory.createSCC14ShippingCode(this.getStrCode());
                    bl = true;
                    break;
                }
                case 19: {
                    this.barcode = BarcodeFactory.createShipmentIdentificationNumber(this.getStrCode());
                    bl = true;
                    break;
                }
                case 20: {
                    this.barcode = BarcodeFactory.createSSCC18(this.getStrCode());
                    bl = true;
                    break;
                }
                case 21: {
                    this.barcode = BarcodeFactory.createStd2of5(this.getStrCode(), this.askCheckSumRequired());
                    bl = true;
                    break;
                }
                case 22: {
                    String string = this.askApplicationIdentifier();
                    if (string.length() <= 0) {
                        string = " ";
                    }
                    this.barcode = BarcodeFactory.createUCC128(string, this.getStrCode());
                    bl = true;
                    break;
                }
                case 23: {
                    this.barcode = BarcodeFactory.createUPCA(this.getStrCode());
                    bl = true;
                    break;
                }
                case 24: {
                    this.barcode = BarcodeFactory.createUSD3(this.getStrCode(), this.askCheckSumRequired());
                    bl = true;
                    break;
                }
                case 25: {
                    this.barcode = BarcodeFactory.createUSD4(this.getStrCode());
                    bl = true;
                    break;
                }
                case 26: {
                    this.barcode = BarcodeFactory.createUSPS(this.getStrCode());
                    bl = true;
                }
            }
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
        if (bl) {
            this.barcode.setBarHeight(this.getIntBarHeight());
            this.barcode.setBarWidth(this.getIntBarWidth());
            this.barcode.setResolution(this.getIntResolution());
            this.barcode.setDrawingText(this.getBoolPrintCode());
            this.barcode.setFont(new Font("Arial", 0, this.getIntFontSize()));
        }
        return bl;
    }

    public boolean askCheckSumRequired() {
        boolean bl = false;
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(this, "Is checksum required for barcode?", "Checksum", 0, 3);
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public String askApplicationIdentifier() {
        String string = "";
        Toolkit.getDefaultToolkit().beep();
        string = JOptionPane.showInputDialog(this, "Please enter an UCC-128 Application Identifier.", "Application Identifier", 1);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutGenerate) {
            if (this.processFieldValues()) {
                if (this.generateBarcode()) {
                    BGViewWindow bGViewWindow = new BGViewWindow(this);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this, "Barcode couldn't get generated.\n\nPlease check Code field for invalid characters.\nSome barcode types also require a certain number of digits.\nEAN-13 and UPC-A are entered without check digit.", "Error", 0);
                }
            }
        } else if (object == this.jbutAbout) {
            BGAboutWindow bGAboutWindow = new BGAboutWindow(this);
        } else if (object == this.jbutQuit) {
            this.quitProgramme();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.jchkbPrintCode) {
            this.boolPrintCode = false;
            if (itemEvent.getStateChange() == 1) {
                this.boolPrintCode = true;
            }
        }
    }

    public static void main(String[] stringArray) {
        BarGen barGen = new BarGen();
    }
}

