/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JWSms
extends JFrame
implements ActionListener {
    public static final int NORMALSMS = 0;
    public static final int FLASHSMS = 1;
    public static final int VOICEMAILONSMS = 2;
    public static final int VOICEMAILOFFSMS = 3;
    public static final int FAXONSMS = 4;
    public static final int FAXOFFSMS = 5;
    public static final int EMAILONSMS = 6;
    public static final int EMAILOFFSMS = 7;
    public static final int OTHERMSGONSMS = 8;
    public static final int OTHERMSGOFFSMS = 9;
    public static final int TESTMODESMS = 10;
    public static final int[] arrBaudRates = new int[]{2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private static final String strApplicationName = "JW SMS";
    public static final String strApplicationVersion = "1.01";
    public static final String strApplicationVDate = "2011-06-04";
    private ImageIcon imgLogo;
    private JLabel jlabLogo;
    private JLabel jlabTitle;
    private JLabel jlabSubTitle;
    private JTextArea jtextareaMsgBody;
    private JLabel jlabRecipient;
    private JTextField jtextfRecipient;
    private JLabel jlabMsgType;
    private JComboBox jcomboMsgType;
    private JLabel jlabSend;
    private JButton jbutSend;
    private JButton jbutPrefs;
    private JButton jbutAbout;
    private JButton jbutQuit;
    private int intSmsType = -1;
    private String strRecipient = null;
    private String strMessage = null;
    private String strCSCA = "";
    private String strPortName = "";
    private int intBaudRate = -1;

    public JWSms(int n, String string, String string2, String string3, String string4) {
        this.intSmsType = n >= 0 && n <= 10 ? n : 0;
        this.strRecipient = string != null && string.length() > 0 ? string : "";
        this.strMessage = string2 != null && string2.length() > 0 ? string2 : "";
        this.strCSCA = string3 != null && string3.length() > 0 ? string3 : "";
        this.strPortName = string4 != null && string4.length() > 0 ? string4 : "COM3";
        this.intBaudRate = 9600;
        this.setTitle(JWSms.getStrApplicationName() + " " + JWSms.getStrApplicationVersion());
        this.initGUI();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JWSms.this.quitApplication();
            }
        };
        this.addWindowListener(windowAdapter);
        this.jtextareaMsgBody.setText(this.strMessage);
        this.jtextfRecipient.setText(this.strRecipient);
        this.jtextareaMsgBody.requestFocusInWindow();
        this.setVisible(true);
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 15, 0, 15);
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.ipadx = 5;
        gridBagConstraints2.ipady = 2;
        URL uRL = this.getClass().getResource("/applogo.png");
        this.imgLogo = uRL != null ? new ImageIcon(uRL) : new ImageIcon();
        this.jlabLogo = new JLabel("", this.imgLogo, 0);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 0, 0, 1, 2, 35, 100);
        gridBagLayout2.setConstraints(this.jlabLogo, gridBagConstraints2);
        jPanel2.add(this.jlabLogo);
        this.jlabTitle = new JLabel(JWSms.getStrApplicationName(), 0);
        gridBagConstraints2.insets = new Insets(40, 40, 10, 40);
        gridBagConstraints2.anchor = 10;
        JWSmsUtil.buildConstraints(gridBagConstraints2, 1, 0, 1, 1, 65, 70);
        Font font = new Font("sanserif", 1, 48);
        this.jlabTitle.setForeground(Color.red);
        this.jlabTitle.setFont(font);
        gridBagLayout2.setConstraints(this.jlabTitle, gridBagConstraints2);
        jPanel2.add(this.jlabTitle);
        this.jlabSubTitle = new JLabel("SMS Messaging Tool", 0);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 40, 80, 40);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 65, 30);
        Font font2 = new Font("sanserif", 1, 16);
        this.jlabSubTitle.setForeground(Color.red);
        this.jlabSubTitle.setFont(font2);
        gridBagLayout2.setConstraints(this.jlabSubTitle, gridBagConstraints2);
        jPanel2.add(this.jlabSubTitle);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 0, 3, 1, 100, 30);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.ipadx = 5;
        gridBagConstraints3.ipady = 2;
        this.jtextareaMsgBody = new JTextArea(new LimitedLengthDocument(160));
        this.jtextareaMsgBody.setWrapStyleWord(true);
        this.jtextareaMsgBody.setLineWrap(true);
        this.jtextareaMsgBody.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.jtextareaMsgBody);
        jScrollPane.setMinimumSize(new Dimension(160, 130));
        jScrollPane.setPreferredSize(new Dimension(220, 150));
        jScrollPane.setBorder(null);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints3, 0, 0, 1, 1, 100, 100);
        gridBagLayout3.setConstraints(jScrollPane, gridBagConstraints3);
        jPanel3.add(jScrollPane);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 66, 50);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout4);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.ipadx = 5;
        gridBagConstraints4.ipady = 2;
        this.jlabRecipient = new JLabel("Recipient:", 0);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints4, 0, 0, 1, 1, 100, 10);
        gridBagLayout4.setConstraints(this.jlabRecipient, gridBagConstraints4);
        jPanel4.add(this.jlabRecipient);
        this.jtextfRecipient = new JTextField(new LimitedLengthDocument(25), "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(4, 0, 10, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints4, 0, 1, 1, 1, 100, 20);
        gridBagLayout4.setConstraints(this.jtextfRecipient, gridBagConstraints4);
        jPanel4.add(this.jtextfRecipient);
        this.jlabMsgType = new JLabel("SMS Type:", 0);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints4, 0, 2, 1, 1, 100, 10);
        gridBagLayout4.setConstraints(this.jlabMsgType, gridBagConstraints4);
        jPanel4.add(this.jlabMsgType);
        this.jcomboMsgType = new JComboBox();
        this.jcomboMsgType.addItem("Normal Text SMS");
        this.jcomboMsgType.addItem("Flash SMS");
        this.jcomboMsgType.addItem("Voice Notification On");
        this.jcomboMsgType.addItem("Voice Notification Off");
        this.jcomboMsgType.addItem("Fax Notification On");
        this.jcomboMsgType.addItem("Fax Notification Off");
        this.jcomboMsgType.addItem("Email Notification On");
        this.jcomboMsgType.addItem("Email Notification Off");
        this.jcomboMsgType.addItem("Other Notification On");
        this.jcomboMsgType.addItem("Other Notification Off");
        if (this.intSmsType == 10) {
            this.jcomboMsgType.addItem("Testmode SMS");
        }
        this.jcomboMsgType.setToolTipText("Select SMS Type");
        this.jcomboMsgType.setSelectedIndex(this.intSmsType);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(4, 0, 20, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints4, 0, 3, 1, 1, 100, 20);
        gridBagLayout4.setConstraints(this.jcomboMsgType, gridBagConstraints4);
        this.jcomboMsgType.addActionListener(this);
        jPanel4.add(this.jcomboMsgType);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 10;
        gridBagConstraints4.ipadx = 10;
        gridBagConstraints4.ipady = 10;
        gridBagConstraints4.insets = new Insets(20, 20, 20, 20);
        this.jbutSend = new JButton("Send");
        this.jbutSend.setMnemonic('s');
        JWSmsUtil.buildConstraints(gridBagConstraints4, 0, 4, 1, 1, 100, 50);
        this.jbutSend.addActionListener(this);
        this.jbutSend.setToolTipText("Send Message");
        gridBagLayout4.setConstraints(this.jbutSend, gridBagConstraints4);
        jPanel4.add(this.jbutSend);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 33, 50);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(15, 20, 15, 20);
        this.jbutPrefs = new JButton("Preferences");
        this.jbutPrefs.setMnemonic('p');
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 33, 20);
        this.jbutPrefs.addActionListener(this);
        this.jbutPrefs.setToolTipText("Preferences");
        gridBagLayout.setConstraints(this.jbutPrefs, gridBagConstraints);
        jPanel.add(this.jbutPrefs);
        this.jbutAbout = new JButton("About");
        this.jbutAbout.setMnemonic('a');
        JWSmsUtil.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 33, 20);
        this.jbutAbout.addActionListener(this);
        this.jbutAbout.setToolTipText("About " + JWSms.getStrApplicationName());
        gridBagLayout.setConstraints(this.jbutAbout, gridBagConstraints);
        jPanel.add(this.jbutAbout);
        this.jbutQuit = new JButton("Quit");
        this.jbutQuit.setMnemonic('q');
        JWSmsUtil.buildConstraints(gridBagConstraints, 2, 2, 1, 1, 34, 20);
        this.jbutQuit.addActionListener(this);
        this.jbutQuit.setToolTipText("Quit Application");
        gridBagLayout.setConstraints(this.jbutQuit, gridBagConstraints);
        jPanel.add(this.jbutQuit);
        this.setContentPane(jPanel);
        this.pack();
        JWSmsUtil.centerComponent(this);
    }

    public static String getStrApplicationName() {
        return strApplicationName;
    }

    public static String getStrApplicationVersion() {
        return strApplicationVersion;
    }

    public static String getStrApplicationVDate() {
        return strApplicationVDate;
    }

    public int getIntSmsType() {
        return this.intSmsType;
    }

    public void setIntSmsType(int n) {
        this.intSmsType = n;
    }

    public String getStrRecipient() {
        return this.strRecipient;
    }

    public void setStrRecipient(String string) {
        this.strRecipient = string;
    }

    public String getStrMessage() {
        return this.strMessage;
    }

    public void setStrMessage(String string) {
        this.strMessage = string;
    }

    public String getStrCSCA() {
        return this.strCSCA;
    }

    public void setStrCSCA(String string) {
        this.strCSCA = string;
    }

    public String getStrPortName() {
        return this.strPortName;
    }

    public void setStrPortName(String string) {
        this.strPortName = string;
    }

    public int getIntBaudRate() {
        return this.intBaudRate;
    }

    public void setIntBaudRate(int n) {
        this.intBaudRate = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutSend) {
            this.strMessage = this.jtextareaMsgBody.getText();
            this.strRecipient = this.jtextfRecipient.getText();
            this.intSmsType = this.jcomboMsgType.getSelectedIndex();
            JWSmsSendWindow jWSmsSendWindow = new JWSmsSendWindow(this);
        } else if (object == this.jbutPrefs) {
            JWSmsPrefsWindow jWSmsPrefsWindow = new JWSmsPrefsWindow(this);
        } else if (object == this.jbutAbout) {
            JWSmsAboutWindow jWSmsAboutWindow = new JWSmsAboutWindow(this);
        } else if (object == this.jbutQuit) {
            this.quitApplication();
        }
    }

    private void quitApplication() {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-r")) {
                if (stringArray.length <= i + 1) continue;
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-m")) {
                if (stringArray.length <= i + 1) continue;
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-c")) {
                if (stringArray.length <= i + 1) continue;
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-p")) {
                if (stringArray.length <= i + 1) continue;
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-t")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help") && !stringArray[i].equals("?")) continue;
            System.out.println(JWSms.getStrApplicationName() + " Version " + JWSms.getStrApplicationVersion() + " " + JWSms.getStrApplicationVDate());
            System.out.println("(c) by Jochen-Matthias Wienke");
            System.out.println("");
            System.out.println("Usage:");
            System.out.println("Start with java or javaw and if desired following optional parameters:");
            System.out.println("-h or ?: Help");
            System.out.println("-r [recipient number]: set a default recipient number");
            System.out.println("-m [message]: set a default message");
            System.out.println("-c [CSCA number]: set a default CSCA number");
            System.out.println("-p [port]: set a default port");
            System.out.println("");
            System.out.println("Example: start javaw JWSms -r \"+4956789\" -m \"My Test Message\" -c \"+49123456\" -p \"COM3\" ");
            System.exit(0);
        }
        if (bl) {
            JWSms jWSms = new JWSms(10, string, string2, string3, string4);
        } else {
            JWSms jWSms = new JWSms(0, string, string2, string3, string4);
        }
    }
}

