/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class JWSmsPrefsWindow
extends JFrame
implements ActionListener {
    private JWSms myOwner;
    private JLabel jlabMain;
    private JTabbedPane jtabPanePrefs;
    private JLabel jlabConHeadline;
    private JLabel jlabPortName;
    private JTextField jtxtfPortName;
    private JLabel jlabBaudRate;
    private JComboBox jcomboBaudRate;
    private JLabel jlabSMSSettingsHeadline;
    private JLabel jlabCSCA;
    private JTextField jtxtfCSCA;
    private JButton jbutOK;
    private JButton jbutCancel;

    public JWSmsPrefsWindow(JWSms jWSms) {
        this.setTitle("Preferences");
        this.setDefaultCloseOperation(2);
        jWSms.setEnabled(false);
        this.myOwner = jWSms;
        this.initGUI();
        this.setVisible(true);
    }

    public void initGUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.jlabMain = new JLabel("Preferences", 0);
        Font font = new Font("sanserif", 1, 30);
        this.jlabMain.setForeground(Color.red);
        this.jlabMain.setFont(font);
        gridBagConstraints.insets = new Insets(15, 20, 20, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 20);
        gridBagLayout.setConstraints(this.jlabMain, gridBagConstraints);
        jPanel.add(this.jlabMain);
        Font font2 = new Font("sanserif", 1, 16);
        this.jtabPanePrefs = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.ipadx = 10;
        gridBagConstraints2.ipady = 10;
        this.jlabConHeadline = new JLabel("Connection Settings", 0);
        this.jlabConHeadline.setFont(font2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(15, 20, 15, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 0, 0, 2, 1, 100, 10);
        gridBagLayout2.setConstraints(this.jlabConHeadline, gridBagConstraints2);
        jPanel2.add(this.jlabConHeadline);
        gridBagConstraints2.ipadx = 5;
        gridBagConstraints2.ipady = 2;
        this.jlabPortName = new JLabel("Port Name:", 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(2, 20, 2, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 15, 10);
        gridBagLayout2.setConstraints(this.jlabPortName, gridBagConstraints2);
        jPanel2.add(this.jlabPortName);
        this.jtxtfPortName = new JTextField(new LimitedLengthDocument(10), this.myOwner.getStrPortName(), 10);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 4, 2, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 85, 10);
        gridBagLayout2.setConstraints(this.jtxtfPortName, gridBagConstraints2);
        jPanel2.add(this.jtxtfPortName);
        this.jlabBaudRate = new JLabel("Baud Rate:", 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(2, 20, 20, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 0, 2, 1, 1, 15, 10);
        gridBagLayout2.setConstraints(this.jlabBaudRate, gridBagConstraints2);
        jPanel2.add(this.jlabBaudRate);
        this.jcomboBaudRate = new JComboBox();
        for (int i = 0; i < JWSms.arrBaudRates.length; ++i) {
            this.jcomboBaudRate.addItem("" + JWSms.arrBaudRates[i]);
            if (JWSms.arrBaudRates[i] != this.myOwner.getIntBaudRate()) continue;
            this.jcomboBaudRate.setSelectedIndex(i);
        }
        this.jcomboBaudRate.setToolTipText("Select Baud Rate");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 4, 20, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints2, 1, 2, 1, 1, 85, 10);
        gridBagLayout2.setConstraints(this.jcomboBaudRate, gridBagConstraints2);
        this.jcomboBaudRate.addActionListener(this);
        jPanel2.add(this.jcomboBaudRate);
        this.jtabPanePrefs.addTab("Connection Settings", jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.ipadx = 10;
        gridBagConstraints3.ipady = 10;
        this.jlabSMSSettingsHeadline = new JLabel("SMS Settings", 0);
        this.jlabSMSSettingsHeadline.setFont(font2);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.insets = new Insets(15, 20, 15, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints3, 0, 0, 2, 1, 100, 10);
        gridBagLayout3.setConstraints(this.jlabSMSSettingsHeadline, gridBagConstraints3);
        jPanel3.add(this.jlabSMSSettingsHeadline);
        gridBagConstraints3.ipadx = 5;
        gridBagConstraints3.ipady = 2;
        this.jlabCSCA = new JLabel("CSCA (optional):", 0);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(2, 20, 20, 0);
        JWSmsUtil.buildConstraints(gridBagConstraints3, 0, 1, 1, 1, 15, 10);
        gridBagLayout3.setConstraints(this.jlabCSCA, gridBagConstraints3);
        jPanel3.add(this.jlabCSCA);
        this.jtxtfCSCA = new JTextField(new LimitedLengthDocument(20), this.myOwner.getStrCSCA(), 20);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(2, 4, 20, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints3, 1, 1, 1, 1, 85, 10);
        gridBagLayout3.setConstraints(this.jtxtfCSCA, gridBagConstraints3);
        jPanel3.add(this.jtxtfCSCA);
        this.jtabPanePrefs.addTab("SMS Settings", jPanel3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 65);
        gridBagLayout.setConstraints(this.jtabPanePrefs, gridBagConstraints);
        jPanel.add(this.jtabPanePrefs);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(30, 20, 15, 20);
        this.jbutOK = new JButton("OK");
        this.jbutOK.setMnemonic('o');
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 15);
        this.jbutOK.addActionListener(this);
        this.jbutOK.setToolTipText("Take over and use preferences");
        gridBagLayout.setConstraints(this.jbutOK, gridBagConstraints);
        jPanel.add(this.jbutOK);
        this.jbutCancel = new JButton("Cancel");
        this.jbutCancel.setMnemonic('c');
        JWSmsUtil.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 15);
        this.jbutCancel.addActionListener(this);
        this.jbutCancel.setToolTipText("Discard changes");
        gridBagLayout.setConstraints(this.jbutCancel, gridBagConstraints);
        jPanel.add(this.jbutCancel);
        this.setContentPane(jPanel);
        this.pack();
        JWSmsUtil.centerComponent(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JWSmsPrefsWindow.this.closeWindow();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutCancel) {
            this.closeWindow();
        } else if (object == this.jbutOK && this.processFieldValues()) {
            this.closeWindow();
        }
    }

    public boolean processFieldValues() {
        boolean bl = false;
        String string = this.jtxtfPortName.getText();
        int n = JWSms.arrBaudRates[0];
        if (this.jcomboBaudRate.getSelectedIndex() >= 0 && this.jcomboBaudRate.getSelectedIndex() < JWSms.arrBaudRates.length) {
            n = JWSms.arrBaudRates[this.jcomboBaudRate.getSelectedIndex()];
        }
        String string2 = this.jtxtfCSCA.getText();
        if (string != null && string.length() > 0) {
            if (string.charAt(string.length() - 1) != ':') {
                if (n >= 0) {
                    if (string2 != null) {
                        this.myOwner.setStrPortName(string);
                        this.myOwner.setIntBaudRate(n);
                        this.myOwner.setStrCSCA(string2);
                        bl = true;
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this, "Please enter a non-null CSCA.", "Error", 0);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this, "Please select a valid Baud Rate.", "Error", 0);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this, "Please enter Port Name without ':' at the end.", "Error", 0);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Please enter a Port Name.", "Error", 0);
        }
        return bl;
    }

    private void closeWindow() {
        this.myOwner.setEnabled(true);
        this.myOwner.validate();
        this.myOwner.requestFocus();
        this.setVisible(false);
        this.myOwner.toFront();
        this.dispose();
    }
}

