/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JWSmsSendWindow
extends JFrame
implements Runnable,
ActionListener {
    private static final long STANDARD = 500L;
    private static final long LONG = 2000L;
    private static final long VERYLONG = 20000L;
    private static final char ctrlZ = '\u001a';
    private JWSms myOwner;
    private Thread threadMy = null;
    private int intStatus = -1;
    private SerialConnection serialconnMy = null;
    private long longDelay = 0L;
    private int intSmsType = -1;
    private String strRecipient = null;
    private String strMessage = null;
    private String strCSCA = "";
    private String strPortName = "";
    private int intBaudRate = -1;
    private JLabel jlabMain;
    private JTextArea jtextareaStatus;
    private JButton jbutClose;

    public JWSmsSendWindow(JWSms jWSms) {
        this.setTitle("Send SMS");
        this.setDefaultCloseOperation(2);
        jWSms.setEnabled(false);
        this.myOwner = jWSms;
        this.intSmsType = jWSms.getIntSmsType();
        this.strRecipient = jWSms.getStrRecipient();
        this.strMessage = jWSms.getStrMessage();
        this.strCSCA = jWSms.getStrCSCA();
        this.strPortName = jWSms.getStrPortName();
        this.intBaudRate = jWSms.getIntBaudRate();
        this.longDelay = 500L;
        this.initGUI();
        if (this.strMessage.length() > 160) {
            this.strMessage = this.strMessage.substring(0, 160);
            this.log("Warning: SMS shortened to 160 characters.\n");
        }
        this.log("SMS Type: " + this.intSmsType + "\n");
        this.setVisible(true);
        this.send();
    }

    public void initGUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(15, 20, 20, 20);
        this.jlabMain = new JLabel("Send SMS", 0);
        Font font = new Font("sanserif", 1, 30);
        this.jlabMain.setForeground(Color.red);
        this.jlabMain.setFont(font);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.jlabMain, gridBagConstraints);
        jPanel.add(this.jlabMain);
        this.jtextareaStatus = new JTextArea();
        this.jtextareaStatus.setWrapStyleWord(true);
        this.jtextareaStatus.setLineWrap(true);
        this.jtextareaStatus.setEditable(false);
        this.jtextareaStatus.setHighlighter(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.jtextareaStatus);
        jScrollPane.setMinimumSize(new Dimension(200, 130));
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        jScrollPane.setBorder(null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 70);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(30, 20, 15, 20);
        this.jbutClose = new JButton("Close");
        this.jbutClose.setMnemonic('c');
        this.jbutClose.setToolTipText("Close Window");
        this.jbutClose.addActionListener(this);
        JWSmsUtil.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 20);
        gridBagLayout.setConstraints(this.jbutClose, gridBagConstraints);
        jPanel.add(this.jbutClose);
        this.setContentPane(jPanel);
        this.pack();
        JWSmsUtil.centerComponent(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JWSmsSendWindow.this.closeWindow();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public int getIntStatus() {
        return this.intStatus;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbutClose) {
            this.closeWindow();
        }
    }

    private void closeWindow() {
        this.myOwner.setEnabled(true);
        this.myOwner.validate();
        this.myOwner.requestFocus();
        this.setVisible(false);
        this.myOwner.toFront();
        this.dispose();
    }

    private int send() {
        if (JWSmsUtil.prepareDialNumber(this.strRecipient).length() >= 3) {
            this.threadMy = new Thread(this);
            this.threadMy.start();
            return 0;
        }
        this.intStatus = -2;
        this.log("Error: Invalid recipient number.");
        return 1;
    }

    public void run() {
        int n = 0;
        long l = 0L;
        SerialParameters serialParameters = new SerialParameters(this.strPortName, this.intBaudRate, 0, 0, 8, 1, 0);
        if (JWSmsUtil.checkPortExists(serialParameters.getPortName())) {
            block99: {
                this.longDelay = 20000L;
                this.log("Send procedure started...\n");
                if (this.intSmsType != 10) {
                    this.log("Opening port and connection...");
                    try {
                        this.serialconnMy = new SerialConnection(serialParameters);
                        this.serialconnMy.openConnection();
                        this.log("Connection successfully opened.\n");
                    }
                    catch (Exception exception) {
                        this.intStatus = -3;
                        this.log("Abborted: error while opening connection.");
                        if (this.serialconnMy == null) break block99;
                        this.serialconnMy = null;
                    }
                }
            }
            if (this.serialconnMy != null || this.intSmsType == 10) {
                boolean bl = false;
                long l2 = new Date().getTime();
                this.longDelay = 500L;
                boolean bl2 = false;
                if (this.strCSCA != null && this.strCSCA.length() > 0) {
                    bl2 = true;
                }
                if (this.intSmsType == 0) {
                    String string = "";
                    while (n < 7 && !bl) {
                        boolean bl3 = bl = new Date().getTime() - l2 > this.longDelay;
                        if (bl && n == 1) {
                            n = -1;
                            this.serialconnMy.send("\u001a");
                        }
                        if (bl2 || !bl2 && n != 3) {
                            string = this.serialconnMy.getIncommingString();
                        }
                        int n2 = -1;
                        try {
                            switch (n) {
                                case 0: {
                                    this.serialconnMy.send("atz");
                                    this.longDelay = 2000L;
                                    l2 = new Date().getTime();
                                    break;
                                }
                                case 1: {
                                    this.longDelay = 500L;
                                    this.serialconnMy.send("ath0");
                                    l2 = new Date().getTime();
                                    break;
                                }
                                case 2: {
                                    n2 = string.indexOf("OK");
                                    if (n2 > -1) {
                                        this.serialconnMy.send("at+cmgf=1");
                                        l2 = new Date().getTime();
                                        break;
                                    }
                                    --n;
                                    break;
                                }
                                case 3: {
                                    if (!bl2) break;
                                    n2 = string.indexOf("OK");
                                    if (n2 > -1) {
                                        this.serialconnMy.send("at+csca=\"" + this.strCSCA + "\"");
                                        l2 = new Date().getTime();
                                        break;
                                    }
                                    --n;
                                    break;
                                }
                                case 4: {
                                    n2 = string.indexOf("OK");
                                    if (n2 > -1) {
                                        this.serialconnMy.send("at+cmgs=\"" + this.strRecipient + "\"");
                                        l2 = new Date().getTime();
                                        break;
                                    }
                                    --n;
                                    break;
                                }
                                case 5: {
                                    n2 = string.indexOf(">");
                                    if (n2 > -1) {
                                        this.serialconnMy.send(this.strMessage + '\u001a');
                                        Thread.sleep(500L);
                                        l2 = new Date().getTime();
                                    } else {
                                        --n;
                                    }
                                    this.longDelay = 20000L;
                                    break;
                                }
                                case 6: {
                                    n2 = string.indexOf("CMGS:");
                                    if (n2 > -1) {
                                        int n3 = string.indexOf("CMGS:");
                                        string = string.substring(n3 + 5);
                                        n3 = string.indexOf("\n");
                                        this.intStatus = 0;
                                        l = Long.parseLong(string.substring(0, n3).trim());
                                        this.log("Message number " + l + " sent successfully.");
                                        break;
                                    }
                                    n2 = string.indexOf("OK");
                                    if (n2 > -1) {
                                        this.intStatus = 0;
                                        this.log("Message sent successfully.");
                                        break;
                                    }
                                    --n;
                                }
                            }
                            ++n;
                            Thread.sleep(150L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (bl) {
                        this.intStatus = -4;
                        this.log("Error: time out occured.");
                        if (n == 0) {
                            this.log("Time out at resetting modem.");
                        } else if (n == 1) {
                            this.log("Time out at hanging up modem.");
                        } else if (n == 2) {
                            this.log("Time out at setting operation mode.");
                        } else if (n == 3) {
                            this.log("Time out at setting CSCA.");
                        } else if (n == 4) {
                            this.log("Time out at setting recipient.");
                        } else if (n == 5) {
                            this.log("Time out at sending message.");
                        } else if (n == 6) {
                            this.log("Message was sent but no re-confirmation from modem was received in time.");
                        }
                    }
                } else {
                    String string = "";
                    byte[] byArray = JWSmsUtil.convertDialNumber(JWSmsUtil.prepareDialNumber(this.strRecipient));
                    String string2 = new String(JWSmsUtil.toHexString(byArray));
                    String string3 = Integer.toHexString(0x100 | JWSmsUtil.prepareDialNumber(this.strRecipient).length()).substring(1).toUpperCase();
                    String string4 = new String(JWSmsUtil.toHexString(JWSmsUtil.compress(JWSmsUtil.convertUnicode2GSM(this.strMessage))));
                    String string5 = Integer.toHexString(0x100 | this.strMessage.length()).substring(1).toUpperCase();
                    int n4 = 0;
                    string = string + "01";
                    string = string + "01";
                    string = string + string3;
                    string = string + "91";
                    string = string + string2;
                    string = string + "00";
                    if (this.intSmsType == 1) {
                        string = string + "10";
                    } else if (this.intSmsType == 2) {
                        string = string + "C8";
                    } else if (this.intSmsType == 3) {
                        string = string + "C0";
                    } else if (this.intSmsType == 4) {
                        string = string + "C9";
                    } else if (this.intSmsType == 5) {
                        string = string + "C1";
                    } else if (this.intSmsType == 6) {
                        string = string + "CA";
                    } else if (this.intSmsType == 7) {
                        string = string + "C2";
                    } else if (this.intSmsType == 8) {
                        string = string + "CB";
                    } else if (this.intSmsType == 9) {
                        string = string + "C3";
                    }
                    string = string + string5;
                    string = string + string4;
                    n4 = string.length() / 2;
                    if (this.intSmsType == 10) {
                        this.log("Port Name: " + serialParameters.getPortName());
                        this.log("Baud Rate: " + serialParameters.getBaudRate() + "\n");
                        this.log("CSCA: " + this.strCSCA + "\n");
                        this.log("Recipient Number: " + this.strRecipient);
                        this.log("Prepared Recipient " + JWSmsUtil.prepareDialNumber(this.strRecipient));
                        this.log("Converted Recipient Number: " + string2);
                        this.log("PDU Recipient Number Length: " + string3 + "\n");
                        this.log("Message: " + this.strMessage);
                        this.log("Converted Message: " + string4);
                        this.log("PDU Message Part Length: " + string5 + "\n");
                        string = string + "01";
                        string = string + string3;
                        string = string + "91";
                        string = string + string2;
                        string = string + "00";
                        string = string + "10";
                        string = string + string5;
                        string = string + string4;
                        this.log("PDU: " + string);
                        this.log("PDU Length: " + n4);
                        this.intStatus = 0;
                    } else {
                        String string6 = "";
                        while (n < 7 && !bl) {
                            boolean bl4 = bl = new Date().getTime() - l2 > this.longDelay;
                            if (bl && n == 1) {
                                n = -1;
                                this.serialconnMy.send("\u001a");
                            }
                            if (bl2 || !bl2 && n != 3) {
                                string6 = this.serialconnMy.getIncommingString();
                            }
                            int n5 = -1;
                            try {
                                switch (n) {
                                    case 0: {
                                        this.serialconnMy.send("atz");
                                        this.longDelay = 2000L;
                                        l2 = new Date().getTime();
                                        break;
                                    }
                                    case 1: {
                                        this.longDelay = 500L;
                                        this.serialconnMy.send("ath0");
                                        l2 = new Date().getTime();
                                        break;
                                    }
                                    case 2: {
                                        n5 = string6.indexOf("OK");
                                        if (n5 > -1) {
                                            this.serialconnMy.send("at+cmgf=0");
                                            l2 = new Date().getTime();
                                            break;
                                        }
                                        --n;
                                        break;
                                    }
                                    case 3: {
                                        if (!bl2) break;
                                        n5 = string6.indexOf("OK");
                                        if (n5 > -1) {
                                            this.serialconnMy.send("at+csca=\"" + this.strCSCA + "\"");
                                            l2 = new Date().getTime();
                                            break;
                                        }
                                        --n;
                                        break;
                                    }
                                    case 4: {
                                        n5 = string6.indexOf("OK");
                                        if (n5 > -1) {
                                            this.serialconnMy.send("at+cmgs=" + n4);
                                            l2 = new Date().getTime();
                                            break;
                                        }
                                        --n;
                                        break;
                                    }
                                    case 5: {
                                        n5 = string6.indexOf(">");
                                        if (n5 > -1) {
                                            this.serialconnMy.send("00" + string + '\u001a');
                                            Thread.sleep(500L);
                                            l2 = new Date().getTime();
                                        } else {
                                            --n;
                                        }
                                        this.longDelay = 20000L;
                                        break;
                                    }
                                    case 6: {
                                        n5 = string6.indexOf("CMGS:");
                                        if (n5 > -1) {
                                            int n6 = string6.indexOf("CMGS:");
                                            string6 = string6.substring(n6 + 5);
                                            n6 = string6.indexOf("\n");
                                            this.intStatus = 0;
                                            l = Long.parseLong(string6.substring(0, n6).trim());
                                            this.log("Message number " + l + " sent successfully.");
                                            break;
                                        }
                                        n5 = string6.indexOf("OK");
                                        if (n5 > -1) {
                                            this.intStatus = 0;
                                            this.log("Message sent successfully.");
                                            break;
                                        }
                                        --n;
                                    }
                                }
                                ++n;
                                Thread.sleep(150L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (bl) {
                            this.intStatus = -4;
                            this.log("Error: time out occured.");
                            if (n == 0) {
                                this.log("Time out at resetting modem.");
                            } else if (n == 1) {
                                this.log("Time out at hanging up modem.");
                            } else if (n == 2) {
                                this.log("Time out at setting operation mode.");
                            } else if (n == 3) {
                                this.log("Time out at setting CSCA.");
                            } else if (n == 4) {
                                this.log("Time out at setting PDU length.");
                            } else if (n == 5) {
                                this.log("Time out at sending message.");
                            } else if (n == 6) {
                                this.log("Message was sent but no re-confirmation from modem was received in time.");
                            }
                        }
                    }
                }
                if (this.intSmsType != 10 && this.serialconnMy != null) {
                    this.serialconnMy.closeConnection();
                    this.serialconnMy = null;
                }
            }
            this.log("\nSend procedure finished.");
        } else {
            this.intStatus = -5;
            this.log("Error: specified comm port was not found or is not serial.");
            this.log("Please check port settings within preferences of this application, ");
            this.log("installation of additional Java Comm API classes ");
            this.log("and general port settings of the operating system. ");
        }
    }

    private void log(String string) {
        this.jtextareaStatus.append(string + "\n");
    }
}

