/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;

public class JWSmsUtil {
    public static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static void centerComponent(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (n > 0 && n2 > 0 && n3 > 0 && n4 > 0) {
            int n5 = (n3 - n) / 2;
            int n6 = (n4 - n2) / 2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            component.setLocation(n5, n6);
        }
    }

    public static String prepareDialNumber(String string) {
        String string2 = "";
        if (string != null && string.length() > 0 && !string.equals("+") && !string.equals("+")) {
            if ((string = string.trim()).length() > 1 && string.startsWith("+")) {
                string = string.substring(1);
            } else if (string.length() > 2 && string.startsWith("00")) {
                string = string.substring(2);
            }
            if (JWSmsUtil.isNumeric(string)) {
                string2 = string;
            }
        }
        return string2;
    }

    public static boolean checkPortExists(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements() && !bl) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (!string.toUpperCase().equals(commPortIdentifier.getName().toUpperCase()) || commPortIdentifier.getPortType() != 1) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isNumeric(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            bl = true;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
        }
        return bl;
    }

    public static byte[] convertDialNumber(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = n / 2;
        if (n % 2 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            switch (string.charAt(n2)) {
                case '0': {
                    int n4 = i;
                    byArray[n4] = (byte)(byArray[n4] + 0);
                    break;
                }
                case '1': {
                    int n5 = i;
                    byArray[n5] = (byte)(byArray[n5] + 1);
                    break;
                }
                case '2': {
                    int n6 = i;
                    byArray[n6] = (byte)(byArray[n6] + 2);
                    break;
                }
                case '3': {
                    int n7 = i;
                    byArray[n7] = (byte)(byArray[n7] + 3);
                    break;
                }
                case '4': {
                    int n8 = i;
                    byArray[n8] = (byte)(byArray[n8] + 4);
                    break;
                }
                case '5': {
                    int n9 = i;
                    byArray[n9] = (byte)(byArray[n9] + 5);
                    break;
                }
                case '6': {
                    int n10 = i;
                    byArray[n10] = (byte)(byArray[n10] + 6);
                    break;
                }
                case '7': {
                    int n11 = i;
                    byArray[n11] = (byte)(byArray[n11] + 7);
                    break;
                }
                case '8': {
                    int n12 = i;
                    byArray[n12] = (byte)(byArray[n12] + 8);
                    break;
                }
                case '9': {
                    int n13 = i;
                    byArray[n13] = (byte)(byArray[n13] + 9);
                }
            }
            if (n2 + 1 < n) {
                switch (string.charAt(n2 + 1)) {
                    case '0': {
                        int n14 = i;
                        byArray[n14] = (byte)(byArray[n14] + 0);
                        break;
                    }
                    case '1': {
                        int n15 = i;
                        byArray[n15] = (byte)(byArray[n15] + 16);
                        break;
                    }
                    case '2': {
                        int n16 = i;
                        byArray[n16] = (byte)(byArray[n16] + 32);
                        break;
                    }
                    case '3': {
                        int n17 = i;
                        byArray[n17] = (byte)(byArray[n17] + 48);
                        break;
                    }
                    case '4': {
                        int n18 = i;
                        byArray[n18] = (byte)(byArray[n18] + 64);
                        break;
                    }
                    case '5': {
                        int n19 = i;
                        byArray[n19] = (byte)(byArray[n19] + 80);
                        break;
                    }
                    case '6': {
                        int n20 = i;
                        byArray[n20] = (byte)(byArray[n20] + 96);
                        break;
                    }
                    case '7': {
                        int n21 = i;
                        byArray[n21] = (byte)(byArray[n21] + 112);
                        break;
                    }
                    case '8': {
                        int n22 = i;
                        byArray[n22] = (byte)(byArray[n22] + 128);
                        break;
                    }
                    case '9': {
                        int n23 = i;
                        byArray[n23] = (byte)(byArray[n23] + 144);
                    }
                }
            } else {
                int n24 = i;
                byArray[n24] = (byte)(byArray[n24] + 240);
            }
            n2 += 2;
        }
        return byArray;
    }

    public static char[] toHexString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[2 * n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i] & 0xF0) {
                case 0: {
                    cArray[n2] = 48;
                    break;
                }
                case 16: {
                    cArray[n2] = 49;
                    break;
                }
                case 32: {
                    cArray[n2] = 50;
                    break;
                }
                case 48: {
                    cArray[n2] = 51;
                    break;
                }
                case 64: {
                    cArray[n2] = 52;
                    break;
                }
                case 80: {
                    cArray[n2] = 53;
                    break;
                }
                case 96: {
                    cArray[n2] = 54;
                    break;
                }
                case 112: {
                    cArray[n2] = 55;
                    break;
                }
                case 128: {
                    cArray[n2] = 56;
                    break;
                }
                case 144: {
                    cArray[n2] = 57;
                    break;
                }
                case 160: {
                    cArray[n2] = 65;
                    break;
                }
                case 176: {
                    cArray[n2] = 66;
                    break;
                }
                case 192: {
                    cArray[n2] = 67;
                    break;
                }
                case 208: {
                    cArray[n2] = 68;
                    break;
                }
                case 224: {
                    cArray[n2] = 69;
                    break;
                }
                case 240: {
                    cArray[n2] = 70;
                }
            }
            ++n2;
            switch (byArray[i] & 0xF) {
                case 0: {
                    cArray[n2] = 48;
                    break;
                }
                case 1: {
                    cArray[n2] = 49;
                    break;
                }
                case 2: {
                    cArray[n2] = 50;
                    break;
                }
                case 3: {
                    cArray[n2] = 51;
                    break;
                }
                case 4: {
                    cArray[n2] = 52;
                    break;
                }
                case 5: {
                    cArray[n2] = 53;
                    break;
                }
                case 6: {
                    cArray[n2] = 54;
                    break;
                }
                case 7: {
                    cArray[n2] = 55;
                    break;
                }
                case 8: {
                    cArray[n2] = 56;
                    break;
                }
                case 9: {
                    cArray[n2] = 57;
                    break;
                }
                case 10: {
                    cArray[n2] = 65;
                    break;
                }
                case 11: {
                    cArray[n2] = 66;
                    break;
                }
                case 12: {
                    cArray[n2] = 67;
                    break;
                }
                case 13: {
                    cArray[n2] = 68;
                    break;
                }
                case 14: {
                    cArray[n2] = 69;
                    break;
                }
                case 15: {
                    cArray[n2] = 70;
                }
            }
            ++n2;
        }
        return cArray;
    }

    public static byte[] convertUnicode2GSM(String string) {
        byte[] byArray = new byte[string.length()];
        block98: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '@': {
                    byArray[i] = 0;
                    continue block98;
                }
                case '$': {
                    byArray[i] = 2;
                    continue block98;
                }
                case '\n': {
                    byArray[i] = 10;
                    continue block98;
                }
                case '\r': {
                    byArray[i] = 13;
                    continue block98;
                }
                case '_': {
                    byArray[i] = 17;
                    continue block98;
                }
                case '\u00df': {
                    byArray[i] = 30;
                    continue block98;
                }
                case ' ': {
                    byArray[i] = 32;
                    continue block98;
                }
                case '!': {
                    byArray[i] = 33;
                    continue block98;
                }
                case '\"': {
                    byArray[i] = 34;
                    continue block98;
                }
                case '#': {
                    byArray[i] = 35;
                    continue block98;
                }
                case '%': {
                    byArray[i] = 37;
                    continue block98;
                }
                case '&': {
                    byArray[i] = 38;
                    continue block98;
                }
                case '\'': {
                    byArray[i] = 39;
                    continue block98;
                }
                case '(': {
                    byArray[i] = 40;
                    continue block98;
                }
                case ')': {
                    byArray[i] = 41;
                    continue block98;
                }
                case '*': {
                    byArray[i] = 42;
                    continue block98;
                }
                case '+': {
                    byArray[i] = 43;
                    continue block98;
                }
                case ',': {
                    byArray[i] = 44;
                    continue block98;
                }
                case '-': {
                    byArray[i] = 45;
                    continue block98;
                }
                case '.': {
                    byArray[i] = 46;
                    continue block98;
                }
                case '/': {
                    byArray[i] = 47;
                    continue block98;
                }
                case '0': {
                    byArray[i] = 48;
                    continue block98;
                }
                case '1': {
                    byArray[i] = 49;
                    continue block98;
                }
                case '2': {
                    byArray[i] = 50;
                    continue block98;
                }
                case '3': {
                    byArray[i] = 51;
                    continue block98;
                }
                case '4': {
                    byArray[i] = 52;
                    continue block98;
                }
                case '5': {
                    byArray[i] = 53;
                    continue block98;
                }
                case '6': {
                    byArray[i] = 54;
                    continue block98;
                }
                case '7': {
                    byArray[i] = 55;
                    continue block98;
                }
                case '8': {
                    byArray[i] = 56;
                    continue block98;
                }
                case '9': {
                    byArray[i] = 57;
                    continue block98;
                }
                case ':': {
                    byArray[i] = 58;
                    continue block98;
                }
                case ';': {
                    byArray[i] = 59;
                    continue block98;
                }
                case '<': {
                    byArray[i] = 60;
                    continue block98;
                }
                case '=': {
                    byArray[i] = 61;
                    continue block98;
                }
                case '>': {
                    byArray[i] = 62;
                    continue block98;
                }
                case '?': {
                    byArray[i] = 63;
                    continue block98;
                }
                case 'A': {
                    byArray[i] = 65;
                    continue block98;
                }
                case 'B': {
                    byArray[i] = 66;
                    continue block98;
                }
                case 'C': {
                    byArray[i] = 67;
                    continue block98;
                }
                case 'D': {
                    byArray[i] = 68;
                    continue block98;
                }
                case 'E': {
                    byArray[i] = 69;
                    continue block98;
                }
                case 'F': {
                    byArray[i] = 70;
                    continue block98;
                }
                case 'G': {
                    byArray[i] = 71;
                    continue block98;
                }
                case 'H': {
                    byArray[i] = 72;
                    continue block98;
                }
                case 'I': {
                    byArray[i] = 73;
                    continue block98;
                }
                case 'J': {
                    byArray[i] = 74;
                    continue block98;
                }
                case 'K': {
                    byArray[i] = 75;
                    continue block98;
                }
                case 'L': {
                    byArray[i] = 76;
                    continue block98;
                }
                case 'M': {
                    byArray[i] = 77;
                    continue block98;
                }
                case 'N': {
                    byArray[i] = 78;
                    continue block98;
                }
                case 'O': {
                    byArray[i] = 79;
                    continue block98;
                }
                case 'P': {
                    byArray[i] = 80;
                    continue block98;
                }
                case 'Q': {
                    byArray[i] = 81;
                    continue block98;
                }
                case 'R': {
                    byArray[i] = 82;
                    continue block98;
                }
                case 'S': {
                    byArray[i] = 83;
                    continue block98;
                }
                case 'T': {
                    byArray[i] = 84;
                    continue block98;
                }
                case 'U': {
                    byArray[i] = 85;
                    continue block98;
                }
                case 'V': {
                    byArray[i] = 86;
                    continue block98;
                }
                case 'W': {
                    byArray[i] = 87;
                    continue block98;
                }
                case 'X': {
                    byArray[i] = 88;
                    continue block98;
                }
                case 'Y': {
                    byArray[i] = 89;
                    continue block98;
                }
                case 'Z': {
                    byArray[i] = 90;
                    continue block98;
                }
                case '\u00c4': {
                    byArray[i] = 91;
                    continue block98;
                }
                case '\u00d6': {
                    byArray[i] = 92;
                    continue block98;
                }
                case '\u00dc': {
                    byArray[i] = 94;
                    continue block98;
                }
                case '\u00a7': {
                    byArray[i] = 95;
                    continue block98;
                }
                case 'a': {
                    byArray[i] = 97;
                    continue block98;
                }
                case 'b': {
                    byArray[i] = 98;
                    continue block98;
                }
                case 'c': {
                    byArray[i] = 99;
                    continue block98;
                }
                case 'd': {
                    byArray[i] = 100;
                    continue block98;
                }
                case 'e': {
                    byArray[i] = 101;
                    continue block98;
                }
                case 'f': {
                    byArray[i] = 102;
                    continue block98;
                }
                case 'g': {
                    byArray[i] = 103;
                    continue block98;
                }
                case 'h': {
                    byArray[i] = 104;
                    continue block98;
                }
                case 'i': {
                    byArray[i] = 105;
                    continue block98;
                }
                case 'j': {
                    byArray[i] = 106;
                    continue block98;
                }
                case 'k': {
                    byArray[i] = 107;
                    continue block98;
                }
                case 'l': {
                    byArray[i] = 108;
                    continue block98;
                }
                case 'm': {
                    byArray[i] = 109;
                    continue block98;
                }
                case 'n': {
                    byArray[i] = 110;
                    continue block98;
                }
                case 'o': {
                    byArray[i] = 111;
                    continue block98;
                }
                case 'p': {
                    byArray[i] = 112;
                    continue block98;
                }
                case 'q': {
                    byArray[i] = 113;
                    continue block98;
                }
                case 'r': {
                    byArray[i] = 114;
                    continue block98;
                }
                case 's': {
                    byArray[i] = 115;
                    continue block98;
                }
                case 't': {
                    byArray[i] = 116;
                    continue block98;
                }
                case 'u': {
                    byArray[i] = 117;
                    continue block98;
                }
                case 'v': {
                    byArray[i] = 118;
                    continue block98;
                }
                case 'w': {
                    byArray[i] = 119;
                    continue block98;
                }
                case 'x': {
                    byArray[i] = 120;
                    continue block98;
                }
                case 'y': {
                    byArray[i] = 121;
                    continue block98;
                }
                case 'z': {
                    byArray[i] = 122;
                    continue block98;
                }
                case '\u00e4': {
                    byArray[i] = 123;
                    continue block98;
                }
                case '\u00f6': {
                    byArray[i] = 124;
                    continue block98;
                }
                case '\u00fc': {
                    byArray[i] = 126;
                    continue block98;
                }
                default: {
                    byArray[i] = 63;
                }
            }
        }
        return byArray;
    }

    public static byte[] compress(byte[] byArray) {
        int n = byArray.length;
        int n2 = n * 7 / 8;
        if (n * 7 % 8 != 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = (byte)((byArray[n3] & 0x7F) >>> n4);
            ++n4;
            if (n3 + 1 < n) {
                int n5 = i;
                byArray2[n5] = (byte)(byArray2[n5] + (byte)(byArray[n3 + 1] << 8 - n4 & 0xFF));
            }
            if (n4 < 7) {
                ++n3;
                continue;
            }
            n4 = 0;
            n3 += 2;
        }
        return byArray2;
    }
}

