/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialConnection
implements SerialPortEventListener,
CommPortOwnershipListener {
    private SerialParameters serialparametersMy;
    private OutputStream osMy;
    private InputStream isMy;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean boolOpen;
    private String strReception = "";

    public SerialConnection(SerialParameters serialParameters) {
        this.serialparametersMy = serialParameters;
        this.boolOpen = false;
    }

    public String getIncommingString() {
        byte[] byArray = this.strReception.getBytes();
        this.strReception = "";
        return new String(byArray);
    }

    public void openConnection() throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)this.serialparametersMy.getPortName());
        }
        catch (NoSuchPortException noSuchPortException) {
            noSuchPortException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sPort = (SerialPort)this.portId.open("SMSConnector", 30000);
        }
        catch (PortInUseException portInUseException) {
            throw new SerialConnectionException(portInUseException.getMessage());
        }
        this.sPort.sendBreak(1000);
        try {
            this.setConnectionParameters();
        }
        catch (SerialConnectionException serialConnectionException) {
            this.sPort.close();
            throw serialConnectionException;
        }
        try {
            this.osMy = this.sPort.getOutputStream();
            this.isMy = this.sPort.getInputStream();
        }
        catch (IOException iOException) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        try {
            this.sPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.portId.addPortOwnershipListener((CommPortOwnershipListener)this);
        this.boolOpen = true;
    }

    public void setConnectionParameters() throws SerialConnectionException {
        int n = this.sPort.getBaudRate();
        int n2 = this.sPort.getDataBits();
        int n3 = this.sPort.getStopBits();
        int n4 = this.sPort.getParity();
        int n5 = this.sPort.getFlowControlMode();
        try {
            this.sPort.setSerialPortParams(this.serialparametersMy.getBaudRate(), this.serialparametersMy.getDatabits(), this.serialparametersMy.getStopbits(), this.serialparametersMy.getParity());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.serialparametersMy.setBaudRate(n);
            this.serialparametersMy.setDatabits(n2);
            this.serialparametersMy.setStopbits(n3);
            this.serialparametersMy.setParity(n4);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(this.serialparametersMy.getFlowControlIn() | this.serialparametersMy.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public void closeConnection() {
        if (!this.boolOpen) {
            return;
        }
        if (this.sPort != null) {
            try {
                this.osMy.close();
                this.isMy.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            this.sPort.close();
            this.portId.removePortOwnershipListener((CommPortOwnershipListener)this);
        }
        this.boolOpen = false;
    }

    public void sendBreak() {
        this.sPort.sendBreak(1000);
    }

    public boolean isOpen() {
        return this.boolOpen;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        switch (serialPortEvent.getEventType()) {
            case 1: {
                while (n != -1) {
                    try {
                        n = this.isMy.read();
                        if (n == -1) break;
                        if ('\r' == (char)n) {
                            stringBuffer.append('\n');
                            continue;
                        }
                        stringBuffer.append((char)n);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                        return;
                    }
                }
                this.strReception = this.strReception + new String(stringBuffer);
                break;
            }
            case 10: {
                this.strReception = this.strReception + "\n--- BREAK RECEIVED ---\n";
            }
        }
    }

    public void ownershipChange(int n) {
    }

    public void send(String string) {
        byte[] byArray = (string + "\n").getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n == 10) {
                n = 13;
            }
            try {
                this.osMy.write(n);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("OutputStream write error: " + iOException);
            }
        }
    }
}

